<?php
require __DIR__ . '/lib.php';

$ip = getClientIp();
[$ok, $remaining, $reset_ts] = checkRateLimit($ip);
$err = null;

// POST => create short link and redirect immediately
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['make_link'])) {
    if (!$ok) {
        $err = "Bạn đã nhận tối đa trong 24h. Vui lòng thử lại sau. ( hoặc qua nhà hàng xóm để tiếp tục =)) )";
    } else {
        $token = createToken();
        $callback = baseUrl() . "/verify.php?token=" . $token;

        $tokens = loadTokens();
        cleanupTokens($tokens);
        $tokens[$token] = [
            'ip' => $ip,
            'created_at' => time(),
            'claimed' => false
        ];
        saveTokens($tokens);

        $shortUrl = shortenWithLink4m($callback);
        if ($shortUrl === false) {
            $err = "Không tạo được link rút gọn. Kiểm tra API token hoặc thử lại.";
            $tokens = loadTokens();
            unset($tokens[$token]);
            saveTokens($tokens);
        } else {
            header("Location: " . $shortUrl, true, 302);
            exit;
        }
    }
}
?>
<!doctype html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title>GFN Free • Nhận tài khoản GeForce NOW miễn phí</title>
<meta name="description" content="Nhận tài khoản GeForce NOW miễn phí. Tối ưu cho điện thoại & máy tính. Vượt link bắt buộc, giới hạn 2 lần/IP/24h.">
<meta property="og:title" content="GFN Free • Nhận tài khoản GeForce NOW miễn phí">
<meta property="og:description" content="Nhận tài khoản GFN miễn phí, giao diện đẹp, có ảnh nền, mượt trên mobile & desktop.">
<meta property="og:type" content="website">
<meta name="theme-color" content="#0f172a">
<style>
  :root{
    --fg:#0f172a; --bg:#ffffff; --muted:#475569; --primary:#16a34a; --ring:#e2e8f0; --card:#ffffff;
    --shadow: 0 10px 35px rgba(2,6,23,.08);
    /* Link ảnh nền của bạn ở đây. Có thể dùng nhiều link, cái đầu tiên sẽ được ưu tiên. */
    --bg-image: url('https://cellphones.com.vn/sforum/wp-content/uploads/2022/12/0306_tong-quan-ve-nhan-vat-yae-miko-genshin-impact.jpg'), url('assets/bg.svg'); 
  }
  *{box-sizing:border-box} html,body{height:100%}
  body{margin:0; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial; color:var(--fg); background:var(--bg);}
  .hero{
    position:relative; isolation:isolate; min-height: 100vh; /* Chỉnh chiều cao để chiếm toàn màn hình */
    display:flex; align-items:center; justify-content:center; /* Căn giữa nội dung */
    background-image: var(--bg-image), radial-gradient(1200px 600px at 70% 10%, #dbeafe 0%, transparent 60%), linear-gradient(#f8fafc, #ffffff);
    background-size: cover, cover, 100% 100%;
    background-position: center, center, center;
    background-repeat: no-repeat;
  }
  .hero::after{
    content:''; position:absolute; inset:0; 
    /* Giảm độ mờ của lớp phủ để ảnh nền rõ hơn */
    background:linear-gradient(180deg, rgba(255,255,255,.55), rgba(255,255,255,.75));
    backdrop-filter: saturate(120%) blur(2px); z-index:-1;
  }
  header{position:absolute; top:0; left:0; right:0; padding:14px 20px; display:flex; justify-content:center; pointer-events:none;}
  .nav{width:100%; max-width:1080px; display:flex; justify-content:space-between; align-items:center; pointer-events:auto;}
  .brand{display:flex; align-items:center; gap:10px; font-weight:800; letter-spacing:-.02em}
  .brand img{width:34px; height:34px}
  .badge{display:inline-flex; align-items:center; gap:8px; font-size:12px; color:#0f172a; background:#f1f5f9; border:1px solid var(--ring); padding:6px 10px; border-radius:999px;}
  .wrap{max-width:1080px; margin:0 auto; padding:20px}
  .hero-inner{
    max-width:760px;
    padding: 40px; /* Tăng padding để panel rộng hơn */
    text-align: center; /* Căn giữa text và các element bên trong */
    
    /* Panel nền trắng mờ phía sau */
    background: rgba(255, 255, 255, 0.65);
    border: 1px solid rgba(226, 232, 240, 0.7);
    border-radius: 24px; /* Bo góc lớn hơn */
    box-shadow: 0 15px 40px rgba(2,6,23,.1);
    backdrop-filter: blur(12px); /* Hiệu ứng kính mờ */
  }
  h1{margin:0 0 10px; font-size: clamp(32px, 5vw, 48px); letter-spacing:-.03em;}
  .lead{color:var(--muted); font-size: clamp(16px, 2.4vw, 19px); line-height:1.6; max-width: 600px; margin: 0 auto;}
  .cta{
    display:flex; gap:12px; flex-wrap:wrap; margin-top:28px;
    justify-content: center; /* Căn giữa button */
  }
  .btn{
    appearance:none; border:none;
    border-radius:16px; /* Bo góc nút bấm */
    padding: 18px 32px; /* Tăng kích thước nút */
    font-weight:800;
    font-size: 18px; /* Tăng cỡ chữ */
    background:var(--primary); color:#fff; cursor:pointer; box-shadow:var(--shadow); transition: transform .1s ease, box-shadow .1s ease;
  }
  .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 12px 30px rgba(22, 163, 74, .3);
  }
  .btn:active{ transform: translateY(1px); box-shadow:var(--shadow); }
  .btn[disabled]{ opacity:.5; cursor:not-allowed; transform: none; box-shadow: none; }
  .btn.ghost{ background:#fff; color:#0f172a; border:1px solid var(--ring) }
  .features{display:grid; grid-template-columns: repeat(2,1fr); gap:14px; margin-top:32px; text-align: left;}
  .feature{background:var(--card); border:1px solid var(--ring); border-radius:14px; padding:12px 14px; display:flex; gap:10px; align-items:center; box-shadow: var(--shadow);}
  .feature svg{flex:none}
  
  .content { display: none; } /* Ẩn section content cũ đi cho gọn */
  
  footer{padding:16px 20px; text-align:center; color:var(--muted); position: absolute; bottom: 0; left: 0; right: 0;}
  @media (max-width:900px){ .features{grid-template-columns: repeat(2,1fr);} }
  @media (max-width:560px){ 
    .features{grid-template-columns: 1fr;}
    .hero { min-height: 100vh; padding: 20px; }
    .hero-inner{ padding: 24px; } 
    h1 { font-size: 28px; }
    .lead { font-size: 16px; }
  }
  @media (prefers-reduced-motion: reduce){ .btn{transition:none} }
</style>
</head>
<body>
<section class="hero">
  <header>
    <div class="nav">
      </div>
    </div>
  </header>
  
  <div class="hero-inner"> <h1>Nhận tài khoản <span style="color:#16a34a">GeForce NOW Ultimate - Premium</span> miễn phí</h1>
    <p class="lead">Nhận tài khoản Geforce Now Premium miễn phí mà không cần phải bỏ tiền ra mua, chỉ cần hoàn thành nhiệm vụ là nhận được</code>.</p>
    
    <form method="post" class="cta">
      <button class="btn" name="make_link" value="1" <?= $ok ? '' : 'disabled' ?>>
        <span style="display: flex; align-items: center; gap: 8px;">
            
            GET ACC
        </span>
      </button>
      
    </form>
    <?php if (!$ok): ?>
        <span class="hint" style="display: block; margin-top: 12px;">Hết lượt. Reset vào: <?= date('H:i d/m/Y', $reset_ts) ?></span>
    <?php else: ?>
        <span class="hint" style="display: block; margin-top: 12px;">Ấn xong sẽ tự chuyển sang trang tiếp theo làm nhiệm vụ</span>
    <?php endif; ?>

    <div class="features">
        <div class="feature">
            <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M3 6h18M3 12h18M3 18h18" stroke="#16a34a" stroke-width="2" stroke-linecap="round"/></svg>
            RTX 4080 - 3060 - 3050 - 1060
        </div>
        <div class="feature">
            <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M5 12l4 4L19 6" stroke="#16a34a" stroke-width="2.4" stroke-linecap="round" stroke-linejoin="round"/></svg>
Miễn phí có thời hạn
        </div>
        <div class="feature">
            <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M12 6v6l4 2" stroke="#16a34a" stroke-width="2.4" stroke-linecap="round" stroke-linejoin="round"/></svg>
            Giới hạn 2 lần / Ngày
        </div>
        <div class="feature">
            <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M4 7h16v10H4z" stroke="#16a34a" stroke-width="2" /><path d="M8 7v10M16 7v10" stroke="#16a34a" stroke-width="2"/></svg>
TK hiện còn: 1000+
</div>
    </div>
  </div>
</section>

<footer>© <?= date('Y') ?> Bản quyền nlacc.site - Nhận tài khoản GFN miễn phí.</footer>

<script>
// Các hàm JS giữ nguyên, không cần thay đổi
function copyText(id){
  const el = document.getElementById(id);
  if(!el) return;
  const text = el.value || el.textContent || "";
  if (navigator.clipboard && window.isSecureContext) {
    navigator.clipboard.writeText(text).then(()=>toast('Đã copy')).catch(()=>fallbackCopy(text));
  } else { fallbackCopy(text); }
}
function fallbackCopy(text){
  const ta = document.createElement('textarea');
  ta.value = text; document.body.appendChild(ta);
  ta.select(); document.execCommand('copy'); ta.remove();
  toast('Đã copy');
}
function toast(msg){
  let t = document.getElementById('toast');
  if(!t){
    t = document.createElement('div');
    t.id='toast';
    t.style.position='fixed'; t.style.bottom='16px'; t.style.left='50%';
    t.style.transform='translateX(-50%)'; t.style.background='#0f172a';
    t.style.color='#fff'; t.style.padding='10px 14px'; t.style.borderRadius='10px';
    t.style.boxShadow='0 8px 30px rgba(2,6,23,.25)'; t.style.zIndex='99';
    document.body.appendChild(t);
  }
  t.textContent = msg; t.style.opacity='1';
  setTimeout(()=>{ t.style.transition='opacity .6s'; t.style.opacity='0'; }, 1200);
}
</script>
</body>
</html>