<?php
require __DIR__ . '/lib.php';

$ip = getClientIp();
[$ok, $remaining, $reset_ts] = checkRateLimit($ip);
$err = null;

// POST => create short link and redirect immediately
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['make_link'])) {
    if (!$ok) {
        $err = "Bạn đã nhận tối đa trong 24h. Vui lòng thử lại sau.";
    } else {
        $token = createToken();
        $callback = baseUrl() . "/verify.php?token=" . $token;

        $tokens = loadTokens();
        cleanupTokens($tokens);
        $tokens[$token] = [
            'ip' => $ip,
            'created_at' => time(),
            'claimed' => false
        ];
        saveTokens($tokens);

        $shortUrl = shortenWithLink4m($callback);
        if ($shortUrl === false) {
            $err = "Không tạo được link rút gọn. Kiểm tra API token hoặc thử lại.";
            $tokens = loadTokens();
            unset($tokens[$token]);
            saveTokens($tokens);
        } else {
            header("Location: " . $shortUrl, true, 302);
            exit;
        }
    }
}
?>
<!doctype html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title>GFN Free • Nhận tài khoản GeForce NOW miễn phí</title>
<meta name="description" content="Nhận tài khoản GeForce NOW miễn phí. Tối ưu cho điện thoại & máy tính. Vượt link bắt buộc, giới hạn 2 lần/IP/24h.">
<meta property="og:title" content="GFN Free • Nhận tài khoản GeForce NOW miễn phí">
<meta property="og:description" content="Nhận tài khoản GFN miễn phí, giao diện đẹp, có ảnh nền, mượt trên mobile & desktop.">
<meta property="og:type" content="website">
<meta name="theme-color" content="#0f172a">
<style>
  :root{
    --fg:#0f172a; --bg:#ffffff; --muted:#475569; --primary:#16a34a; --ring:#e2e8f0; --card:#ffffff;
    --shadow: 0 10px 35px rgba(2,6,23,.08);
    --bg-image: url('assets/bg.jpg'), url('assets/bg.svg'); /* đặt ảnh nền tại assets/bg.jpg để override */
  }
  *{box-sizing:border-box} html,body{height:100%}
  body{margin:0; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial; color:var(--fg); background:var(--bg);}
  .hero{
    position:relative; isolation:isolate; min-height: 62vh; display:flex; align-items:center;
    background-image: var(--bg-image), radial-gradient(1200px 600px at 70% 10%, #dbeafe 0%, transparent 60%), linear-gradient(#f8fafc, #ffffff);
    background-size: cover, cover, 100% 100%;
    background-position: center, center, center;
    background-repeat: no-repeat;
  }
  .hero::after{
    content:''; position:absolute; inset:0; background:linear-gradient(180deg, rgba(255,255,255,.85), rgba(255,255,255,.95));
    backdrop-filter: saturate(120%) blur(2px); z-index:-1;
  }
  header{position:absolute; top:0; left:0; right:0; padding:14px 20px; display:flex; justify-content:center; pointer-events:none;}
  .nav{width:100%; max-width:1080px; display:flex; justify-content:space-between; align-items:center; pointer-events:auto;}
  .brand{display:flex; align-items:center; gap:10px; font-weight:800; letter-spacing:-.02em}
  .brand img{width:34px; height:34px}
  .badge{display:inline-flex; align-items:center; gap:8px; font-size:12px; color:#0f172a; background:#f1f5f9; border:1px solid var(--ring); padding:6px 10px; border-radius:999px;}
  .wrap{max-width:1080px; margin:0 auto; padding:20px}
  .hero-inner{max-width:760px; padding:80px 20px 24px;}
  h1{margin:0 0 10px; font-size: clamp(28px, 5vw, 46px); letter-spacing:-.03em;}
  .lead{color:var(--muted); font-size: clamp(15px, 2.4vw, 18px); line-height:1.6}
  .cta{display:flex; gap:12px; flex-wrap:wrap; margin-top:18px}
  .btn{appearance:none; border:none; border-radius:14px; padding:14px 18px; font-weight:800; background:var(--primary); color:#fff; cursor:pointer; box-shadow:var(--shadow); transition: transform .06s ease;}
  .btn:active{ transform: translateY(1px) }
  .btn[disabled]{ opacity:.5; cursor:not-allowed; }
  .btn.ghost{ background:#fff; color:#0f172a; border:1px solid var(--ring) }
  .features{display:grid; grid-template-columns: repeat(4,1fr); gap:14px; margin-top:22px}
  .feature{background:var(--card); border:1px solid var(--ring); border-radius:14px; padding:12px 14px; display:flex; gap:10px; align-items:flex-start; box-shadow: var(--shadow);}
  .feature svg{flex:none}
  .content{padding:26px 20px}
  .grid{display:grid; grid-template-columns:1.2fr .8fr; gap:20px}
  .panel{background:#fff; border:1px solid var(--ring); border-radius:16px; padding:18px; box-shadow: var(--shadow);}
  .copy-wrap{display:flex; gap:10px; border:1px solid var(--ring); padding:10px 12px; border-radius:12px; background:#f8fafc}
  .copy-input{flex:1; min-width:200px; border:none; outline:none; background:transparent;}
  .hint{color:var(--muted); font-size:13px}
  footer{padding:16px 20px; text-align:center; color:var(--muted)}
  @media (max-width:900px){ .grid{grid-template-columns:1fr} .features{grid-template-columns: repeat(2,1fr);} }
  @media (max-width:560px){ .features{grid-template-columns: 1fr;} .hero{min-height: 54vh} .hero-inner{padding-top:64px} }
  @media (prefers-reduced-motion: reduce){ .btn{transition:none} }
</style>
</head>
<body>
<section class="hero">
  <header>
    <div class="nav">
      <div class="brand">
        <img src="assets/logo-gfn.svg" alt="GFN logo" loading="lazy">
        <span>GFN Free</span>
      </div>
      <div class="badge">
        <svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M4 12h16M12 4v16" stroke="#0f172a" stroke-width="2" stroke-linecap="round"/></svg>
        2 lần / IP / 24h
      </div>
    </div>
  </header>
  <div class="wrap hero-inner">
    <h1>Nhận tài khoản <span style="color:#16a34a">GeForce NOW</span> miễn phí</h1>
    <p class="lead">Giao diện đẹp mắt, mượt mà trên điện thoại & máy tính. Vượt link để xác thực và hệ thống sẽ phát ngẫu nhiên tài khoản dạng <code>tk:mk</code> (không xóa khỏi danh sách).</p>
    <div class="features">
      <div class="feature">
        <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M3 6h18M3 12h18M3 18h18" stroke="#16a34a" stroke-width="2" stroke-linecap="round"/></svg>
        Tối ưu Mobile & Desktop
      </div>
      <div class="feature">
        <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M5 12l4 4L19 6" stroke="#16a34a" stroke-width="2.4" stroke-linecap="round" stroke-linejoin="round"/></svg>
        Vượt link bắt buộc
      </div>
      <div class="feature">
        <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M12 6v6l4 2" stroke="#16a34a" stroke-width="2.4" stroke-linecap="round" stroke-linejoin="round"/></svg>
        Giới hạn 2 lần / 24h
      </div>
      <div class="feature">
        <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M4 7h16v10H4z" stroke="#16a34a" stroke-width="2" /><path d="M8 7v10M16 7v10" stroke="#16a34a" stroke-width="2"/></svg>
        Danh sách không bị xóa
      </div>
    </div>
    <form method="post" class="cta">
      <button class="btn" name="make_link" value="1" <?= $ok ? '' : 'disabled' ?>>Nhận tài khoản ngay</button>
      <?php if (!$ok): ?>
        <span class="hint">Hết lượt. Reset vào: <?= date('H:i d/m/Y', $reset_ts) ?></span>
      <?php else: ?>
        <span class="hint">Tạo link xong sẽ tự chuyển sang trang vượt link.</span>
      <?php endif; ?>
    </form>
  </div>
</section>

<section class="content">
  <div class="wrap grid">
    <div class="panel">
      <h3 style="margin:0 0 8px">Cách hoạt động</h3>
      <ol style="margin:10px 0 0; padding-left:20px; line-height:1.65">
        <li>Nhấn nút <b>Nhận tài khoản ngay</b> để tạo link rút gọn (Link4m).</li>
        <li>Hệ thống sẽ <b>chuyển bạn</b> sang trang vượt link để xác thực.</li>
        <li>Hoàn tất, bạn sẽ được chuyển về trang <b>Kết quả</b> và nhận tài khoản.</li>
      </ol>
      <p class="hint" style="margin-top:10px">Quản trị: cập nhật danh sách tại <code>accounts/accounts.txt</code> — mỗi dòng 1 tài khoản <code>tk:mk</code>.</p>
    </div>
    <div class="panel">
      <h3 style="margin:0 0 8px">Tuỳ chỉnh nền</h3>
      <p class="hint">Đặt ảnh nền tuỳ ý tại <code>assets/bg.jpg</code>. Nếu ảnh không có, trang sẽ dùng <code>assets/bg.svg</code> hoặc gradient mặc định.</p>
      <div class="copy-wrap" style="margin-top:8px">
        <input id="bgPath" class="copy-input" readonly value="assets/bg.jpg" />
        <button type="button" class="btn ghost" onclick="copyText('bgPath')">Copy đường dẫn</button>
      </div>
    </div>
  </div>
</section>

<footer>© <?= date('Y') ?> GFN Free • Theme trắng • Hình nền tuỳ chỉnh</footer>

<script>
function copyText(id){
  const el = document.getElementById(id);
  if(!el) return;
  const text = el.value || el.textContent || "";
  if (navigator.clipboard && window.isSecureContext) {
    navigator.clipboard.writeText(text).then(()=>toast('Đã copy')).catch(()=>fallbackCopy(text));
  } else { fallbackCopy(text); }
}
function fallbackCopy(text){
  const ta = document.createElement('textarea');
  ta.value = text; document.body.appendChild(ta);
  ta.select(); document.execCommand('copy'); ta.remove();
  toast('Đã copy');
}
function toast(msg){
  let t = document.getElementById('toast');
  if(!t){
    t = document.createElement('div');
    t.id='toast';
    t.style.position='fixed'; t.style.bottom='16px'; t.style.left='50%';
    t.style.transform='translateX(-50%)'; t.style.background='#0f172a';
    t.style.color='#fff'; t.style.padding='10px 14px'; t.style.borderRadius='10px';
    t.style.boxShadow='0 8px 30px rgba(2,6,23,.25)'; t.style.zIndex='99';
    document.body.appendChild(t);
  }
  t.textContent = msg; t.style.opacity='1';
  setTimeout(()=>{ t.style.transition='opacity .6s'; t.style.opacity='0'; }, 1200);
}
</script>
</body>
</html>
