<?php
require __DIR__ . '/lib.php';

$ip = getClientIp();
$token = $_GET['token'] ?? '';
$ok = false;
$msg = '';
$account = null;
$user = ''; $pass = '';

if (!$token || !preg_match('/^[a-f0-9]{32}$/', $token)) {
    $msg = "Token không hợp lệ.";
} else {
    $tokens = loadTokens();
    cleanupTokens($tokens);

    if (!isset($tokens[$token])) {
        $msg = "Token không tồn tại hoặc đã hết hạn.";
    } else {
        $info = $tokens[$token];
        $created = (int)($info['created_at'] ?? 0);
        $claimed = (bool)($info['claimed'] ?? false);
        $boundIp = (string)($info['ip'] ?? '');

        if ((time() - $created) > TOKEN_TTL) {
            unset($tokens[$token]);
            saveTokens($tokens);
            $msg = "Token đã hết hạn. Vui lòng quay lại trang chủ để tạo link mới.";
        } elseif ($claimed) {
            $msg = "Token đã được dùng.";
        } elseif ($boundIp !== $ip) {
            $msg = "Token không khớp IP. Hãy tạo link mới từ thiết bị/ mạng hiện tại.";
        } else {
            [$allow, $remaining, $reset_ts] = checkRateLimit($ip);
            if (!$allow) {
                $msg = "Bạn đã đạt giới hạn nhận trong 24h. Thử lại sau.";
            } else {
                $acc = getRandomAccount();
                if (!$acc) {
                    $msg = "Chưa có tài khoản để phát. Thêm vào accounts/accounts.txt";
                } else {
                    $tokens[$token]['claimed'] = true;
                    saveTokens($tokens);
                    recordUsage($ip);
                    $ok = true;
                    $account = trim($acc);
                    $parts = explode(':', $account, 2);
                    $user = $parts[0] ?? '';
                    $pass = $parts[1] ?? '';
                }
            }
        }
    }
}
?>
<!doctype html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
<title>Kết quả • GFN Free</title>
<meta name="description" content="Kết quả nhận tài khoản GeForce NOW miễn phí.">
<style>
  :root{
    --fg:#0f172a; --bg:#ffffff; --muted:#475569; --primary:#16a34a; --ring:#e2e8f0; --card:#ffffff;
    --shadow: 0 10px 35px rgba(2,6,23,.08);
  }
  *{box-sizing:border-box}
  body{margin:0; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Arial; color:var(--fg); background:var(--bg);}
  header{padding:14px 20px; border-bottom:1px solid var(--ring); background:#fff}
  .nav{max-width:1080px; margin:0 auto; display:flex; justify-content:space-between; align-items:center}
  .brand{display:flex; align-items:center; gap:10px; font-weight:800; letter-spacing:-.02em}
  .brand img{width:28px; height:28px}
  .wrap{max-width:900px; margin:0 auto; padding:22px 20px}
  .card{background:#fff; border:1px solid var(--ring); border-radius:16px; padding:18px; box-shadow:var(--shadow)}
  .success{display:flex; gap:12px; align-items:flex-start; background:#ecfdf5; border:1px solid #d1fae5; color:#065f46; padding:12px 14px; border-radius:12px}
  .error{display:flex; gap:12px; align-items:flex-start; background:#fef2f2; border:1px solid #fee2e2; color:#991b1b; padding:12px 14px; border-radius:12px}
  .kvs{display:grid; grid-template-columns:1fr; gap:12px; margin-top:12px}
  .kv{display:flex; align-items:center; gap:10px; border:1px solid var(--ring); border-radius:12px; padding:10px 12px; background:#f8fafc}
  .label{min-width:110px; color:#0f172a; font-weight:700}
  .val{flex:1; overflow:auto; font-family: ui-monospace, SFMono-Regular, Menlo, Consolas, monospace}
  .row{display:flex; gap:10px; flex-wrap:wrap}
  .btn{appearance:none; border:none; border-radius:12px; padding:10px 14px; font-weight:800; cursor:pointer}
  .btn.primary{background:#16a34a; color:#fff}
  .btn.ghost{background:#fff; border:1px solid var(--ring); color:#0f172a}
  .footer{padding:16px 20px; text-align:center; color:var(--muted)}
  @media (min-width:680px){ .kvs{grid-template-columns:1fr 1fr} }
</style>
</head>
<body>
<header>
  <div class="nav">
    <div class="brand">
      <img src="assets/logo-gfn.svg" alt="GFN logo" loading="lazy">
      <span>GFN Free</span>
    </div>
    <a class="btn ghost" href="<?= h(baseUrl()) ?>">Trang chủ</a>
  </div>
</header>

<div class="wrap">
  <div class="card">
    <?php if ($ok): ?>
      <div class="success">
        <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M20 7L10 17L5 12" stroke="#065f46" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/></svg>
        <div>
          <strong>Nhận tài khoản thành công!</strong>
          <p style="margin:4px 0 0" class="hint">Sao chép từng mục hoặc copy toàn bộ <code>tk:mk</code> bên dưới.</p>
        </div>
      </div>

      <div class="kvs">
        <div class="kv">
          <div class="label">Username</div>
          <div id="uval" class="val"><?= h($user) ?></div>
          <button class="btn ghost" onclick="copyText('uval')">Copy</button>
        </div>
        <div class="kv">
          <div class="label">Password</div>
          <div id="pval" class="val"><?= h($pass) ?></div>
          <button class="btn ghost" onclick="copyText('pval')">Copy</button>
        </div>
        <div class="kv" style="grid-column:1/-1">
          <div class="label">tk:mk</div>
          <div id="fullval" class="val"><?= h($account) ?></div>
          <button class="btn ghost" onclick="copyText('fullval')">Copy</button>
        </div>
      </div>

      <div style="height:12px"></div>
      <div class="row">
        <a class="btn ghost" href="<?= h(baseUrl()) ?>">Nhận tiếp (khi đủ điều kiện)</a>
        <button class="btn primary" onclick="copyText('fullval')">Copy tk:mk</button>
      </div>

    <?php else: ?>
      <div class="error">
        <svg width="22" height="22" viewBox="0 0 24 24" fill="none"><path d="M18 6L6 18M6 6l12 12" stroke="#991b1b" stroke-width="2.5" stroke-linecap="round"/></svg>
        <div>
          <strong>Không thành công</strong>
          <p style="margin:4px 0 0"><?= h($msg) ?></p>
        </div>
      </div>
      <div style="height:12px"></div>
      <a class="btn primary" href="<?= h(baseUrl()) ?>">Về trang chủ</a>
    <?php endif; ?>
  </div>
</div>

<footer class="footer">© <?= date('Y') ?> GFN Free • Copy nhanh từng mục</footer>

<script>
function copyText(elemId){
  const el = document.getElementById(elemId);
  if(!el) return;
  const text = el.innerText || el.textContent || "";
  if (navigator.clipboard && window.isSecureContext) {
    navigator.clipboard.writeText(text).then(()=>toast('Đã copy')).catch(()=>fallbackCopy(text));
  } else { fallbackCopy(text); }
}
function fallbackCopy(text) {
  const ta = document.createElement('textarea');
  ta.value = text; document.body.appendChild(ta);
  ta.select(); document.execCommand('copy'); ta.remove();
  toast('Đã copy');
}
function toast(msg){
  let t = document.getElementById('toast');
  if(!t){
    t = document.createElement('div');
    t.id='toast';
    t.style.position='fixed'; t.style.bottom='16px'; t.style.left='50%';
    t.style.transform='translateX(-50%)'; t.style.background='#0f172a';
    t.style.color='#fff'; t.style.padding='10px 14px'; t.style.borderRadius='10px';
    t.style.boxShadow='0 8px 30px rgba(2,6,23,.25)'; t.style.zIndex='99';
    document.body.appendChild(t);
  }
  t.textContent = msg; t.style.opacity='1';
  setTimeout(()=>{ t.style.transition='opacity .6s'; t.style.opacity='0'; }, 1200);
}
</script>
</body>
</html>
